/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.util;

import com.alexander.mutantmore.explosions.CustomExplosion;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MiscUtils {
    public static Random random = new Random();
    public static final Predicate<Entity> ALIVE = p_213685_0_ -> p_213685_0_.m_6084_();

    public static <T extends Entity> List<T> getNearbyNonLivingEntities(Class<T> entityClass, Level level, Entity entityNear, AABB boundingBox) {
        List list = level.m_6443_(entityClass, boundingBox, p_186450_ -> true);
        return list;
    }

    public static String getTranslated(String string) {
        return Component.m_237115_((String)string).getString();
    }

    public static void maybeDisableShield(Mob mob, Player p_21425_, ItemStack p_21426_, ItemStack p_21427_) {
        if (!p_21426_.m_41619_() && !p_21427_.m_41619_() && p_21426_.m_41720_() instanceof AxeItem && p_21427_.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)mob) * 0.05f;
            if (random.nextFloat() < f) {
                p_21425_.m_36335_().m_41524_(Items.f_42740_, 100);
                p_21425_.m_5810_();
                mob.f_19853_.m_7605_((Entity)p_21425_, (byte)30);
            }
        }
    }

    public static boolean isHolding(LivingEntity livingEntity, Item item) {
        return livingEntity.m_21205_().m_41720_() == item || livingEntity.m_21206_().m_41720_() == item;
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof Player && livingEntity.m_21254_()) {
            ((Player)livingEntity).m_36335_().m_41524_(livingEntity.m_21120_(livingEntity.m_7655_()).m_41720_(), ticks);
            livingEntity.m_5810_();
            livingEntity.f_19853_.m_7605_((Entity)livingEntity, (byte)30);
        }
    }

    public static boolean randomPercent(int chance) {
        int randomInt = random.nextInt(100);
        return randomInt < chance;
    }

    public static float distanceToBlockPos(Entity mob, BlockPos pos) {
        float f = (float)(mob.m_20185_() - (double)pos.m_123341_());
        float f1 = (float)(mob.m_20186_() - (double)pos.m_123342_());
        float f2 = (float)(mob.m_20189_() - (double)pos.m_123343_());
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float radToDeg(float rad) {
        return rad * 57.295776f;
    }

    public static float degToRad(float deg) {
        return deg * ((float)Math.PI / 180);
    }

    public static void awardMutantMoreAdvancement(ServerPlayer player, String location, String criteriaName) {
        Advancement adv = ServerLifecycleHooks.getCurrentServer().m_129889_().m_136041_(new ResourceLocation("mutantmore", location));
        if (adv != null) {
            player.m_8960_().m_135988_(adv, criteriaName);
        }
    }

    public static boolean canHarmBasedOnTeamAndTag(TagKey<EntityType<?>> tag, Entity entity, Entity target, Entity owner, Predicate<Entity> ownerPredicate) {
        Entity entityForTeam;
        Entity entity2 = entityForTeam = owner != null ? owner : entity;
        if (owner == null) {
            return true;
        }
        if (owner != null && owner instanceof Mob && ((Mob)owner).m_5448_() != null && ((Mob)owner).m_5448_() == target) {
            return true;
        }
        if (tag != null && target.m_6095_().m_204039_(tag) && entityForTeam.m_5647_() == null && target.m_5647_() == null) {
            return false;
        }
        if (entity.m_5647_() != null && target.m_5647_() != null && entityForTeam.m_5647_().m_83536_(target.m_5647_())) {
            return false;
        }
        return owner != null && (ownerPredicate != null && ownerPredicate.test(owner) || ownerPredicate == null);
    }

    public static Explosion customExplosion(Level level, Entity explodingEntity, DamageSource damageSource, ExplosionDamageCalculator damageCalculator, double x, double y, double z, float explosionSize, boolean createsFire, Explosion.BlockInteraction blockInteraction, SoundEvent explosionSound, SoundSource explosionSoundSource, ParticleOptions explosionParticle, ParticleOptions secondaryExplosionParticle, float entityDamage, boolean damageRelativeToDistance, boolean friendlyFire) {
        CustomExplosion explosion = new CustomExplosion(level, explodingEntity, damageSource, damageCalculator, x, y, z, explosionSize, createsFire, blockInteraction, explosionSound, explosionSoundSource, explosionParticle, secondaryExplosionParticle, entityDamage, damageRelativeToDistance, friendlyFire);
        explosion.m_46061_();
        explosion.m_46075_(true);
        return explosion;
    }

    public static float randomSoundPitch() {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }
}

